"use client";

import * as React from "react";
import { useParams, useRouter } from "next/navigation";
import { useTranslations } from "next-intl";
import CreatePurchaseOrderPage from "@/app/inventory/purchase-orders/create/page";

type POData = {
  id: string;
  poNumber: string;
  supplierId: string;
  supplierEmail: string;
  supplierPhone: string;
  poDate: string;
  expectedDate: string;
  status: "draft" | "sent" | "partial" | "closed";
  currency: string;
  terms: string;
  deliverTo: string;
  notes: string;
  lines: any[];
  charges: {
    shipping: number;
    other: number;
  };
};

// Sample data until real API
async function fetchPO(id: string): Promise<POData> {
  return {
    id,
    poNumber: "PO-000123",
    supplierId: "s1",
    supplierEmail: "sales@acme.com",
    supplierPhone: "+1 555 123",
    poDate: "2025-08-01",
    expectedDate: "2025-08-05",
    status: "draft",
    currency: "QAR",
    terms: "net30",
    deliverTo: "main",
    notes: "Please deliver ASAP.",
    lines: [
      {
        id: "1",
        item: "i1",
        description: "Latex",
        unit: "box",
        qty: 10,
        price: 12.5,
        discount: 0,
        tax: 5,
      },
    ],
    charges: {
      shipping: 10,
      other: 5,
    },
  };
}

export default function EditPurchaseOrderPage() {
  const t = useTranslations("PurchaseOrders");
  const router = useRouter();
  const params = useParams();
  const id = params?.id as string;

  const [initialData, setInitialData] = React.useState<POData | null>(null);

  React.useEffect(() => {
    if (id) {
      fetchPO(id).then(setInitialData);
    }
  }, [id]);

  const onSave = () => {
    console.log("SAVE CHANGES", initialData);
    router.push("/inventory/purchase-orders");
  };

  if (!initialData) {
    return <div className="p-6">{t("loading")}...</div>;
  }

  return (
    <CreatePurchaseOrderPage initialData={initialData} onSave={onSave} />
  );
}
